﻿<?php
/**
 * Retrieves and creates the wp-config.php file.
 *
 * The permissions for the base directory must allow for writing files in order
 * for the wp-config.php to be created using this page.
 *
 * @package WordPress
 * @subpackage Administration
 */

/**
 * We are installing.
 *
 * @package WordPress
 */
define('WP_INSTALLING', true);

/**#@+
 * These three defines are required to allow us to use require_wp_db() to load
 * the database class while being wp-content/db.php aware.
 * @ignore
 */
define('ABSPATH', dirname(dirname(__FILE__)).'/');
define('WPINC', 'wp-includes');
define('WP_CONTENT_DIR', ABSPATH . 'wp-content');
/**#@-*/

require_once(ABSPATH . WPINC . '/compat.php');
require_once(ABSPATH . WPINC . '/functions.php');
require_once(ABSPATH . WPINC . '/classes.php');

if (!file_exists(ABSPATH . 'wp-config-sample.php'))
	wp_die('Potrebna nam je a wp-config-sample.php datoteka za instalaciju. Molimo vas da je ponovo dodate u vašu WordPress instalaciju.');

$configFile = file(ABSPATH . 'wp-config-sample.php');

if ( !is_writable(ABSPATH))
	wp_die("Nije moguće zapisivati u diretoriji. Morat ćete promijeniti dozvole u vašem WordPress direktoriju ili ručno napraviti wp-config.php datoteku.");

// Check if wp-config.php has been created
if (file_exists(ABSPATH . 'wp-config.php'))
	wp_die("<p>Datoteka 'wp-config.php' već postoji. Ako trebate resetovati bilo kakve konfiguracijske stavke u ovoj datoteci, prvo je obrišite. Sada možete probati pokrenuti <a href='install.php'>instalaciju</a>.</p>");

// Check if wp-config.php exists above the root directory but is not part of another install
if (file_exists(ABSPATH . '../wp-config.php') && ! file_exists(ABSPATH . '../wp-settings.php'))
	wp_die("<p>Datoteka 'wp-config.php' već postoji i nalazi se jedan nivo iznad vaše WordPress instalacije. Ako trebate resetovati bilo kakve konfiguracijske stavke u ovoj datoteci, prvo je obrišite. Sada možete probati pokrenuti <a href='install.php'>instalaciju</a>.</p>");

if (isset($_GET['step']))
	$step = $_GET['step'];
else
	$step = 0;

/**
 * Display setup wp-config.php file header.
 *
 * @ignore
 * @since 2.3.0
 * @package WordPress
 * @subpackage Installer_WP_Config
 */
function display_header() {
	header( 'Content-Type: text/html; charset=utf-8' );
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>WordPress &rsaquo; Podešavanje konfiguracijske datoteke</title>
<link rel="stylesheet" href="css/install.css" type="text/css" />

</head>
<body>
<h1 id="logo"><img alt="WordPress" src="images/wordpress-logo.png" /></h1>
<?php
}//end function display_header();

switch($step) {
	case 0:
		display_header();
?>

<p>Dobro došli u WordPress. Prije nego počnemo, potrebne su nam neke informacije o bazi podataka. Morat ćete znati sljedeće stavke prije nego nastavak bude moguć.</p>
<ol>
	<li>Ime baze podataka</li>
	<li>Korisničko ime baze podataka</li>
	<li>Šifra baze podataka</li>
	<li>Poslužitelj baze podataka</li>
	<li>Prefiks tabele (ukoliko želite imati više WordPress instalacija unutar jedne baze podataka) </li>
</ol>
<p><strong>Ako iz bilo kojeg razlog automatsko pravljenje datoteke ne uspije, ne sekirajte se. Ovdje se samo popunjavaju informacije o bazi podaka koje se upisuju u konfiguracijsku datoteku. Jednostavno možete otvoriti <code>wp-config-sample.php</code> u nekom uređivaču za tekst, popuniti informacije i sačuvati datoteku kao <code>wp-config.php</code>. </strong></p>
<p>U svakom slučaju, ove informacije vam dostavlja vaš web poslužitelj. Ako nemate ove informacije, morat ćete ga kontaktirati prije nego nastavite. Ako ste spremni&hellip;</p>

<p class="step"><a href="setup-config.php?step=1" class="button">Započnimo!</a></p>
<?php
	break;

	case 1:
		display_header();
	?>
<form method="post" action="setup-config.php?step=2">
	<p>Ispod trebate da unesete detalje o bazi podataka. Ako niste sigurni šta upisati, kontaktirajte vašeg web poslužitelja. </p>
	<table class="form-table">
		<tr>
			<th scope="row"><label for="dbname">Ime baze podataka</label></th>
			<td><input name="dbname" id="dbname" type="text" size="25" value="wordpress" /></td>
			<td>Ime baze u kojoj će se čuvati WordPressovi podaci. </td>
		</tr>
		<tr>
			<th scope="row"><label for="uname">Korisničko ime</label></th>
			<td><input name="uname" id="uname" type="text" size="25" value="username" /></td>
			<td>Vaše MySQL korisničko ime</td>
		</tr>
		<tr>
			<th scope="row"><label for="pwd">Šifra</label></th>
			<td><input name="pwd" id="pwd" type="text" size="25" value="password" /></td>
			<td>...i MySQL šifra.</td>
		</tr>
		<tr>
			<th scope="row"><label for="dbhost">Poslužitelj baze podataka</label></th>
			<td><input name="dbhost" id="dbhost" type="text" size="25" value="localhost" /></td>
			<td>U 99% slučajeva nećete morati mijenjati ovu vrijednost.</td>
		</tr>
		<tr>
			<th scope="row"><label for="prefix">Prefiks tabele</label></th>
			<td><input name="prefix" id="prefix" type="text" id="prefix" value="wp_" size="25" /></td>
			<td>Ako želite da imate više instalacija WordPressa u jednoj bazi podataka, promijenite ovu vrijednost.</td>
		</tr>
	</table>
	<p class="step"><input name="submit" type="submit" value="Pošalji" class="button" /></p>
</form>
<?php
	break;

	case 2:
	$dbname  = trim($_POST['dbname']);
	$uname   = trim($_POST['uname']);
	$passwrd = trim($_POST['pwd']);
	$dbhost  = trim($_POST['dbhost']);
	$prefix  = trim($_POST['prefix']);
	if (empty($prefix)) $prefix = 'wp_';

	// Test the db connection.
	/**#@+
	 * @ignore
	 */
	define('DB_NAME', $dbname);
	define('DB_USER', $uname);
	define('DB_PASSWORD', $passwrd);
	define('DB_HOST', $dbhost);
	/**#@-*/

	// We'll fail here if the values are no good.
	require_wp_db();
	if ( !empty($wpdb->error) )
		wp_die($wpdb->error->get_error_message());

	$handle = fopen(ABSPATH . 'wp-config.php', 'w');

	foreach ($configFile as $line_num => $line) {
		switch (substr($line,0,16)) {
			case "define('DB_NAME'":
				fwrite($handle, str_replace("ovdjeupisiteimebaze", $dbname, $line));
				break;
			case "define('DB_USER'":
				fwrite($handle, str_replace("'ovdjeupisitekorisnickoime'", "'$uname'", $line));
				break;
			case "define('DB_PASSW":
				fwrite($handle, str_replace("'ovdjeupisitesifru'", "'$passwrd'", $line));
				break;
			case "define('DB_HOST'":
				fwrite($handle, str_replace("localhost", $dbhost, $line));
				break;
			case '$table_prefix  =':
				fwrite($handle, str_replace('wp_', $prefix, $line));
				break;
			default:
				fwrite($handle, $line);
		}
	}
	fclose($handle);
	chmod(ABSPATH . 'wp-config.php', 0666);

	display_header();
?>
<p>Zar ovo nije bilo lahko? Ovaj dio instalacije je završen. WordPress sada može komunicirati sa bazom podataka. Ako ste spremni, vrijeme je da&hellip;</p>

<p class="step"><a href="install.php" class="button">započnete instalaciju</a></p>
<?php
	break;
}
?>
</body>
</html>
