<?php
/**
 * @package Hello_Dolly
 * @version 1.6
 */
/*
Plugin Name: Hello Dolly
Plugin URI: http://wordpress.org/extend/plugins/hello-dolly/
Description:  &#1576;&#1735; &#1605;&#1735;&#1606;&#1583;&#1575;&#1602;&#1604;&#1575; &#1602;&#1608;&#1588;&#1735;&#1662; &#1602;&#1608;&#1610;&#1735;&#1604;&#1594;&#1575;&#1606; &#1602;&#1609;&#1587;&#1578;&#1735;&#1585;&#1605;&#1575; &#1574;&#1749;&#1605;&#1749;&#1587;. &#1574;&#1735; Louis Armstrong &#1578;&#1749;&#1585;&#1609;&#1662;&#1609;&#1583;&#1609;&#1606; &#1574;&#1744;&#1610;&#1578;&#1609;&#1604;&#1609;&#1662; &#1583;&#1575;&#1709; &#1670;&#1609;&#1602;&#1575;&#1585;&#1594;&#1575;&#1606; &#1574;&#1609;&#1603;&#1603;&#1609; &#1587;&#1734;&#1586; &laquo;Hello, Dolly&raquo; &#1594;&#1575; &#1605;&#1735;&#1580;&#1749;&#1587;&#1587;&#1749;&#1605;&#1604;&#1749;&#1606;&#1711;&#1749;&#1606; &#1588;&#1735; &#1583;&#1749;&#1739;&#1585;&#1583;&#1609;&#1603;&#1609; &#1576;&#1575;&#1585;&#1604;&#1609;&#1602; &#1603;&#1609;&#1588;&#1609;&#1604;&#1749;&#1585;&#1606;&#1609;&#1709; &#1574;&#1736;&#1605;&#1609;&#1583; &#1739;&#1749; &#1602;&#1609;&#1586;&#1594;&#1609;&#1606;&#1604;&#1609;&#1602;&#1604;&#1609;&#1585;&#1609;&#1606;&#1609;&#1709; &#1587;&#1609;&#1605;&#1739;&#1608;&#1604;&#1609;. &#1576;&#1735; &#1602;&#1609;&#1587;&#1578;&#1735;&#1585;&#1605;&#1575; &#1602;&#1608;&#1586;&#1594;&#1609;&#1578;&#1609;&#1604;&#1587;&#1575;&#1548; &#1576;&#1575;&#1588;&#1602;&#1735;&#1585;&#1735;&#1588; &#1576;&#1744;&#1578;&#1609;&#1583;&#1609;&#1603;&#1609; &#1726;&#1749;&#1585; &#1576;&#1609;&#1585; &#1574;&#1744;&#1603;&#1585;&#1575;&#1606;&#1606;&#1609;&#1709; &#1587;&#1608;&#1604; &#1578;&#1749;&#1585;&#1749;&#1662; &#1610;&#1735;&#1602;&#1609;&#1585;&#1609; &#1576;&#1736;&#1585;&#1580;&#1609;&#1603;&#1609;&#1583;&#1749; <cite>Hello, Dolly</cite> &#1606;&#1575;&#1582;&#1588;&#1609;&#1587;&#1609;&#1606;&#1609;&#1709; &#1578;&#1744;&#1603;&#1609;&#1587;&#1578;&#1609; &#1576;&#1609;&#1585; &#1605;&#1609;&#1587;&#1585;&#1575;&#1583;&#1609;&#1606; &#1574;&#1609;&#1582;&#1578;&#1609;&#1610;&#1575;&#1585;&#1609; &#1578;&#1749;&#1585;&#1578;&#1609;&#1662;&#1578;&#1749; &#1603;&#1734;&#1585;&#1587;&#1609;&#1578;&#1609;&#1604;&#1609;&#1583;&#1735;.
Author: Matt Mullenweg
Version: 1.6
Author URI: http://ma.tt/
*/

function hello_dolly_get_lyric() {
	/** These are the lyrics to Hello Dolly */
	$lyrics = "Hello, Dolly
Well, hello, Dolly
It's so nice to have you back where you belong
You're lookin' swell, Dolly
I can tell, Dolly
You're still glowin', you're still crowin'
You're still goin' strong
We feel the room swayin'
While the band's playin'
One of your old favourite songs from way back when
So, take her wrap, fellas
Find her an empty lap, fellas
Dolly'll never go away again
Hello, Dolly
Well, hello, Dolly
It's so nice to have you back where you belong
You're lookin' swell, Dolly
I can tell, Dolly
You're still glowin', you're still crowin'
You're still goin' strong
We feel the room swayin'
While the band's playin'
One of your old favourite songs from way back when
Golly, gee, fellas
Find her a vacant knee, fellas
Dolly'll never go away
Dolly'll never go away
Dolly'll never go away again";

	// Here we split it into lines
	$lyrics = explode( "\n", $lyrics );

	// And then randomly choose a line
	return wptexturize( $lyrics[ mt_rand( 0, count( $lyrics ) - 1 ) ] );
}

// This just echoes the chosen line, we'll position it later
function hello_dolly() {
	$chosen = hello_dolly_get_lyric();
	echo "<p id='dolly'>$chosen</p>";
}

// Now we set that function up to execute when the admin_notices action is called
add_action( 'admin_notices', 'hello_dolly' );

// We need some CSS to position the paragraph
function dolly_css() {
	// This makes sure that the positioning is also good for right-to-left languages
	$x = is_rtl() ? 'left' : 'right';

	echo "
	<style type='text/css'>
	#dolly {
		float: $x;
		padding-$x: 15px;
		padding-top: 5px;		
		margin: 0;
		font-size: 11px;
	}
	</style>
	";
}

add_action( 'admin_head', 'dolly_css' );

?>
