<?php
/**
 * wp-config.php fitxategia sortzen du.
 *
 * Karpetaren baimenek fitxategiak idaztea baimendu behar dute horrela
 * wp-config.php sortu ahal izateko.
 *
 * @package WordPress
 * @subpackage Administration
 */

/**
 * Instalatzen ari gara.
 *
 * @package WordPress
 */
define('WP_INSTALLING', true);

/**
 * Hau atomatikoa da.
 */
define('WP_SETUP_CONFIG', true);

/**
 * Desaktibatu erroreen txostena
 *
 * Jarri error_reporting ( E_ALL ) edo error_reporting( E_ALL | E_STRICT )
 * debug lanak egiteko
 */
error_reporting(0);

/**#@+
 * Honekin require_wp_db() erabili dezakegu datu-basearen klasea
 * kargatzeko betiere wp-content/db.php dagoen artean
 * @ignore
 */
define('ABSPATH', dirname(dirname(__FILE__)).'/');
define('WPINC', 'wp-includes');
define('WP_CONTENT_DIR', ABSPATH . 'wp-content');
define('WP_DEBUG', false);
/**#@-*/

require_once(ABSPATH . WPINC . '/load.php');
require_once(ABSPATH . WPINC . '/version.php');
wp_check_php_mysql_versions();

require_once(ABSPATH . WPINC . '/compat.php');
require_once(ABSPATH . WPINC . '/functions.php');
require_once(ABSPATH . WPINC . '/class-wp-error.php');

if (!file_exists(ABSPATH . 'wp-config-sample.php'))
	wp_die('Barkatu, wp-config-sample.php fitxategi bat egon behar da hau egiteko. Kopiatu ezazu berriro fitxategi hau WordPressen instalazio karpetatik.');

$configFile = file(ABSPATH . 'wp-config-sample.php');

// Egiaztatu wp-config.php badagoela
if (file_exists(ABSPATH . 'wp-config.php'))
	wp_die("<p>'wp-config.php' fitxategia badago. Konfigurazioaren atalen bat aldatu nahi baduzu, ezabatu egin beharko duzu. <a href='install.php'>Orain instalatzen saiatu zaitezke</a>.</p>");

// wp-config.php gorago dagoen egiaztatu, beste instalazio baten parte izan ez dadin
if (file_exists(ABSPATH . '../wp-config.php') && ! file_exists(ABSPATH . '../wp-settings.php'))
	wp_die("<p>'wp-config.php' fitxategia maila bat gorago dago. Konfigurazioaren atalen bat aldatu nahi baduzu, ezabatu egin beharko duzu. <a href='install.php'>Orain instalatzen saiatu zaitezke</a>.</p>");

if (isset($_GET['step']))
	$step = $_GET['step'];
else
	$step = 0;

/**
 * wp-config.php fitxategiaren goiburua erakusten du.
 *
 * @ignore
 * @since 2.3.0
 * @package WordPress
 * @subpackage Installer_WP_Config
 */
function display_header() {
	header( 'Content-Type: text/html; charset=utf-8' );
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>WordPress konfigurazio fitxategia</title>
<link rel="stylesheet" href="css/install.css" type="text/css" />

</head>
<body>
<h1 id="logo"><img alt="WordPress" src="images/wordpress-logo.png" /></h1>
<?php
}//end function display_header();

switch($step) {
	case 0:
		display_header();
?>

<p>Ongietorri WordPressera. Hasi aurretik datu-basearen inguruko informazioa jakin behar duzu:</p>
<ol>
	<li>Datu-basearen izena</li>
	<li>Datu-basera sartzeko erabiltzaile-izena</li>
	<li>Datu-basera sartzeko pasahitza</li>
	<li>Datu-basearen zerbitzaria</li>
	<li>Taulen aurrizkia (WordPress bat baino gehiago datu-base berean gorde nahi baduzu)</li>
</ol>
<p><strong>Zerbaitegatik fitxategia sortzea ez badabil, lasai. Egiten duen gauza bakarra fitxategian datu-basearen informazioa idaztea da.  wp-config.php fitxategia ireki eta datuak bertan idatzi ditzakezu.</strong></p>
<p>Kasu gehienetan, informazio hau zure ostatatze zerbitzuak emango dizu. Datuak ez badakizkizu, jarri harremanetan eurekin jarraitu aurretik.</p>

<p class="step"><a href="setup-config.php?step=1<?php if ( isset( $_GET['noapi'] ) ) echo '&amp;noapi'; ?>" class="button">Aurrera!</a></p>
<?php
	break;

	case 1:
		display_header();
	?>
<form method="post" action="setup-config.php?step=2">
	<p>Datu-basearekin konektatzeko datuak idatzi hemen:</p>
	<table class="form-table">
		<tr>
			<th scope="row"><label for="dbname">Datu-basearen izena</label></th>
			<td><input name="dbname" id="dbname" type="text" size="25" value="wordpress" /></td>
			<td>WPen datuak gordeko diren datu-basearen izena </td>
		</tr>
		<tr>
			<th scope="row"><label for="uname">Erabiltzaile-izena</label></th>
			<td><input name="uname" id="uname" type="text" size="25" value="erabiltzaileizena" /></td>
			<td>MySQL zerbitzariko zure erabiltzailea</td>
		</tr>
		<tr>
			<th scope="row"><label for="pwd">Pasahitza</label></th>
			<td><input name="pwd" id="pwd" type="text" size="25" value="pasahitza" /></td>
			<td>MySQL zerbitzariko zure pasahitza</td>
		</tr>
		<tr>
			<th scope="row"><label for="dbhost">Datu-basearen zerbitzaria</label></th>
			<td><input name="dbhost" id="dbhost" type="text" size="25" value="localhost" /></td>
			<td><code>localhost</code> jarrita ez badabil, jarri kontaktuan zure ostatatze zerbitzuarekin.</td>
		</tr>
		<tr>
			<th scope="row"><label for="prefix">Taularen aurrizkia</label></th>
			<td><input name="prefix" id="prefix" type="text" id="prefix" value="wp_" size="25" /></td>
			<td>Datu-base berean WordPress instalazio bat baino gehiago jarri nahi baduzu aldatu balio hau.</td>
		</tr>
	</table>

	<?php if ( isset( $_GET['noapi'] ) ) { ?><input name="noapi" type="hidden" value="true" /><?php } ?>
	<p class="step"><input name="submit" type="submit" value="Aurrera" class="button" /></p>
</form>
<?php
	break;

	case 2:
	$dbname  = trim($_POST['dbname']);
	$uname   = trim($_POST['uname']);
	$passwrd = trim($_POST['pwd']);
	$dbhost  = trim($_POST['dbhost']);
	$prefix  = trim($_POST['prefix']);
	if ( empty($prefix) )
		$prefix = 'wp_';

	// $prefix-ek hizkiak, zenbakiak eta gidoi baxuak bakarrik izan ditzake
	if ( preg_match( '|[^a-z0-9_]|i', $prefix ) )
		wp_die( /*WP_I18N_BAD_PREFIX*/'<strong>ERROREA</strong>: "Taularen aurrizkiak" hizkiak, zenbakiak eta gidoi baxuak bakarrik izan ditzakes.'/*/WP_I18N_BAD_PREFIX*/ );

	// Konexioa probatu
	/**#@+
	 * @ignore
	 */
	define('DB_NAME', $dbname);
	define('DB_USER', $uname);
	define('DB_PASSWORD', $passwrd);
	define('DB_HOST', $dbhost);
	/**#@-*/

	// Datuak zuzenak ez badira errorea gertatutko da
	require_wp_db();
	if ( ! empty( $wpdb->error ) ) {
		$back = '<p class="step"><a href="setup-config.php?step=1" onclick="javascript:history.go(-1);return false;" class="button">Saiatu berriz</a></p>';
		wp_die( $wpdb->error->get_error_message() . $back );
	}

	// Gakoak sortu
	$no_api = isset( $_POST['noapi'] );
	require_once( ABSPATH . WPINC . '/plugin.php' );
	require_once( ABSPATH . WPINC . '/l10n.php' );
	require_once( ABSPATH . WPINC . '/pomo/translations.php' );
	if ( ! $no_api ) {
		require_once( ABSPATH . WPINC . '/class-http.php' );
		require_once( ABSPATH . WPINC . '/http.php' );
		wp_fix_server_vars();
		/**#@+
		 * @ignore
		 */
		function get_bloginfo() {
			return ( ( is_ssl() ? 'https://' : 'http://' ) . $_SERVER['HTTP_HOST'] . str_replace( $_SERVER['PHP_SELF'], '/wp-admin/setup-config.php', '' ) );
		}
		/**#@-*/
		$secret_keys = wp_remote_get( 'https://api.wordpress.org/secret-key/1.1/salt/' );
	}

	if ( $no_api || is_wp_error( $secret_keys ) ) {
		$secret_keys = array();
		require_once( ABSPATH . WPINC . '/pluggable.php' );
		for ( $i = 0; $i < 8; $i++ ) {
			$secret_keys[] = wp_generate_password( 64, true, true );
		}
	} else {
		$secret_keys = explode( "\n", wp_remote_retrieve_body( $secret_keys ) );
		foreach ( $secret_keys as $k => $v ) {
			$secret_keys[$k] = substr( $v, 28, 64 );
		}
	}
	$key = 0;

	foreach ($configFile as $line_num => $line) {
		switch (substr($line,0,16)) {
			case "define('DB_NAME'":
				$configFile[$line_num] = str_replace("datubaseizena", $dbname, $line);
				break;
			case "define('DB_USER'":
				$configFile[$line_num] = str_replace("'erabiltzaileizena'", "'$uname'", $line);
				break;
			case "define('DB_PASSW":
				$configFile[$line_num] = str_replace("'pasahitza'", "'$passwrd'", $line);
				break;
			case "define('DB_HOST'":
				$configFile[$line_num] = str_replace("localhost", $dbhost, $line);
				break;
			case '$table_prefix  =':
				$configFile[$line_num] = str_replace('wp_', $prefix, $line);
				break;
			case "define('AUTH_KEY":
			case "define('SECURE_A":
			case "define('LOGGED_I":
			case "define('NONCE_KE":
			case "define('AUTH_SAL":
			case "define('SECURE_A":
			case "define('LOGGED_I":
			case "define('NONCE_SA":
				$configFile[$line_num] = str_replace('idatzi hemen ausazko gako bat ', $secret_keys[$key++], $line );
				break;
		}
	}
	if ( ! is_writable(ABSPATH) ) :
		display_header();
?>
<p>Ezin izan da ezer <code>wp-config.php</code> fitxategian idatzi.</p>
<p><code>wp-config.php</code> eskuz osatu dezakezu eta hauxe idatzi bertan:</p>
<textarea cols="98" rows="15" class="code"><?php
		foreach( $configFile as $line ) {
			echo htmlentities($line, ENT_COMPAT, 'UTF-8');
		}
?></textarea>
<p>Hau egin ostean egin klik "Instalazioa hasi"n</p>
<p class="step"><a href="install.php" class="button">Instalazioa hasi</a></p>
<?php
	else :
		$handle = fopen(ABSPATH . 'wp-config.php', 'w');
		foreach( $configFile as $line ) {
			fwrite($handle, $line);
		}
		fclose($handle);
		chmod(ABSPATH . 'wp-config.php', 0666);
		display_header();
?>
<p>Dena ondo joan da! Bukatu duzu instalazioaren zati hau  WordPress datu-basearekin komunikatu daiteke. Prest bazaude hauxe da momentua&hellip;</p>

<p class="step"><a href="install.php" class="button">Instalazioa hasi</a></p>
<?php
	endif;
	break;
}
?>
</body>
</html>
